//
//  BIAssistantTimerSetup.h
//  Assistant
//
//  Created by Alykhan Jetha on 09/04/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <MCAssistant/MCAssistantAbstractPane.h>

@class MCShortcutGrabber;

@interface BIAssistantTimerSetup : MCAssistantAbstractPane {
	MCShortcutGrabber *grabber;
	
	NSDictionary *currentStartTimerConfig;
	NSDictionary *currentToggerTimerWinConfig;
	
	IBOutlet NSTextField *startTimerKeyField;
	IBOutlet NSTextField *toggleTimerKeyField;

	IBOutlet NSTextField *startTimerLabelField;
	IBOutlet NSTextField *toggleTimerLabelField;

	IBOutlet NSButton *floatTimerWindowSwitch;
	IBOutlet NSButton *useHotKeysSwitch;
	
	IBOutlet NSButton *startTimerButton;
	IBOutlet NSButton *toggleDisplayButton;
	
}

- (void)validateHotKeyDisplay;

- (IBAction)changeStartTimerKey:(id)sender;
- (IBAction)changeToggleTimerKey:(id)sender;

- (IBAction)toggleFloatTimerWindow:(id)sender;
- (IBAction)toggleUseHotKeys:(id)sender;

- (IBAction)help:(id)sender;

- (NSDictionary *)currentStartTimerConfig;
- (void)setCurrentStartTimerConfig:(NSDictionary *)aCurrentStartTimerConfig;
- (NSDictionary *)currentToggerTimerWinConfig;
- (void)setCurrentToggerTimerWinConfig:(NSDictionary *)aCurrentToggerTimerWinConfig;

- (void)unregisterCurrentHotKeys;
- (void)registerCurrentHotKeys;

@end
